#!/bin/sh

set -e

cd /app

# Applying migrations
python3 manage.py migrate --skip-checks

echo "Applying seeds..."
python3 manage.py loaddata app/seeds/settings.json
python3 manage.py loaddata app/seeds/pages.json
python3 manage.py loaddata app/seeds/admin_interface.json
python3 manage.py loaddata app/seeds/auth.json

echo "Handling assets/static files..."
python3 manage.py collectstatic --no-input --skip-checks

echo "Installation completed successfully."
# container restart is required!
